/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.fddi;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.common.Boolean;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionFddiStation
implements StatusMapper,
TableStatusNamer {
    private static String fddiBundle = "ibm.nways.fddi.Resources";
    private boolean loggingOn = false;

    public ActionFddiStation() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionFddiStation");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        if (this.loggingOn) {
            System.out.println("StationPeerWrap = " + statusModelInfo.get("Panel.FddimibSMTPeerWrapFlag"));
            System.out.println("StationCFState  = " + statusModelInfo.get("Panel.FddimibSMTCFState"));
        }
        Boolean boolean_ = (Boolean)statusModelInfo.get("Panel.FddimibSMTPeerWrapFlag");
        Integer n2 = (Integer)statusModelInfo.get("Panel.FddimibSMTCFState");
        int n3 = n2;
        StatusAndExplain statusAndExplain = this.evaluatePeerWrapAndCFState(boolean_, n3, n);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFDDIStation - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(fddiBundle, "STATUS_TABLE_STATION");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionFddiStation - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(fddiBundle, "STATUS_NAME_STATION", objectArray);
        return i18NMsgFormat;
    }

    private StatusAndExplain evaluatePeerWrapAndCFState(Boolean boolean_, int n, int n2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n2)};
        objectArray[0] = new I18NMsgFormat(fddiBundle, "stationstatus", objectArray2);
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(fddiBundle, "cf0");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(fddiBundle, "cf1");
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(fddiBundle, "cf2");
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(fddiBundle, "cf3");
                break;
            }
            case 5: {
                statusAndExplain.statType = StatusType.CRITICAL;
                objectArray[1] = new I18NString(fddiBundle, "cf4");
                break;
            }
            case 6: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf5");
                break;
            }
            case 7: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf6");
                break;
            }
            case 8: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf7");
                break;
            }
            case 9: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf8");
                break;
            }
            case 10: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf9");
                break;
            }
            case 11: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf10");
                break;
            }
            case 12: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[1] = new I18NString(fddiBundle, "cf11");
                break;
            }
            case 13: {
                if (boolean_.toString().equals("false")) {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray[1] = new I18NString(fddiBundle, "cf12");
                    break;
                }
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray[0] = new I18NMsgFormat(fddiBundle, "stationwrap", objectArray2);
                objectArray[1] = new I18NString(fddiBundle, "true");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray[1] = new I18NString(fddiBundle, "unknown");
            }
        }
        statusAndExplain.explain = new I18NGiblets(fddiBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("statType = " + statusAndExplain.statType);
            System.out.println("explain  = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionFddiStation.this = ActionFddiStation.this;
        }
    }
}

